<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMV_customer}}".
 *
 */
class GMVCustomer extends base\GMVCustomer
{
    /**
     * @inheritdoc $primaryKey
     */
    public static function primaryKey()
    {
        return ["customer_cod"];
    }

    /**
     * Funzione che restituisce i metodi di pagamento
     */
    public function getPaymentMethods(){
        return GMVPaymentMethod::findAll(['payment_cod' => ['A01', 'B10', $this->payment_term_cod]]);
    }

    public function checkPaymentMethod($paymentMethodCod){
        foreach($this->paymentMethods as $paymentMethod){
            if($paymentMethod->payment_cod == $paymentMethodCod){
                return true;
            }
        }
        return false;
    }

    public static function getLanguage(){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $nationCod = trim($customerUser->customer->nation_cod);
        foreach (Yii::$app->params['language'] as $key => $value){
            if($key == $nationCod){
                return $value;
            }
        }
        return "it";
    }
}
