<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use Emberware\Evidia\Model\GotifySender\behaviors\SendNotification;
use bitcream\gmvricambi\custom\common\behaviors\OrderItemUpdateParentBehaviors;
/**
 * This is the model class for table "{{%order_item}}".
 *
 */
class OrderItem extends base\OrderItem
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'send-notification' => [
                'class' => SendNotification::className(),
                'messageType' => [
                    'update' => 'orderItemUpdated',
                    'delete' => 'orderItemDeleted',
                    'create' => 'orderItemCreated',
                ]
            ],
            'update_parent' => [
                'class' => OrderItemUpdateParentBehaviors::className(),
            ],
        ]);
    }

    /**
     * Gets query for [[Order]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrder()
    {
        return $this->hasOne(Order::className(), ['id' => 'order_id']);
    }

    /**
     * Gets query for [[Order]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvArticle()
    {
        return $this->hasOne(GMVArticle::className(), ['article_cod' => 'article_cod']);
    }

    public static function searchOrderItem($articleCod, $order){
        $orderItem = OrderItem::find()->where(['article_cod' => $articleCod, 'order_id' => $order->id, 'status' => '30' ])->one();
        if($orderItem){
            return $orderItem;
        }
        return;
    }

}
