<?php

namespace bitcream\gmvricambi\custom\api\controllers;

use yii\rest\ActiveController;
use bitcream\gmvricambi\custom\api\models\OrderItem;
use Yii;
use yii\db\Query;
use yii\data\ActiveDataFilter;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use bitcream\gmvricambi\custom\common\behaviors\OrderItemUpdateParentBehaviors;
 
class OrderItemController extends ActiveController
{
    public $modelClass = 'bitcream\gmvricambi\custom\api\models\OrderItem';

    public function behaviors()
    {
        return array_merge(parent::behaviors(), [            
            'update_parent' => [
                'class' => OrderItemUpdateParentBehaviors::className(),
            ],
        ]);
    }

    /**
     * @inheritdoc
    */

//     public function behaviors(): array
//     {
//       return array_merge(parent::behaviors(), [

//           // For cross-domain AJAX request
//           // 'corsFilter'  => [
//           //     'class' => \yii\filters\Cors::className(),
//           //     'cors'  => [
//           //         // restrict access to domains:
//           //         'Origin'                           => static::allowedDomains(),
//           //         // 'Access-Control-Request-Method'    => ['GET'],
//           //         'Access-Control-Allow-Credentials' => true,
//           //         'Access-Control-Allow-Headers' => ['*'],
//           //         // 'Access-Control-Max-Age'           => 3600,                 // Cache (seconds)
//           //     ],
//           // ],
//         //   'authenticator' => [
//         //       'class' => \Kakadu\Yii2JwtAuth\JwtBearerAuth::class,
//         //       'except' => ['options'],
//         //   ],
//           'access'        => [
//               'class' => AccessControl::class,
//               'rules' => [
//                   [
//                       'allow' => true,
//                       'roles' => ['@'],
//                   ],
//               ],
//           ],
//       ]);
//   }

    public function actions(){
        $actions = parent::actions();

        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];

        return $actions;
    }

    public function prepareDataProvider(){

        $filter = new ActiveDataFilter([
            'searchModel' => 'bitcream\gmvricambi\custom\api\models\OrderItemSearch'
        ]);
        
        $filterCondition = null;
        
        // You may load filters from any source. For example,
        // if you prefer JSON in request body,
        // use Yii::$app->request->getBodyParams() below:
        if ($filter->load(\Yii::$app->request->get())) { 
            $filterCondition = $filter->build();
            if ($filterCondition === false) {
                // Serializer would get errors out of it
                return $filter;
            }
        }
        $query = OrderItem::find();
                
        return new ActiveDataProvider([
            'query' => $query,
        ]);
    }   
}
