<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVCustomer;

/**
 * GMVCustomerSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVCustomer`.
 */
class GMVCustomerSearch extends GMVCustomer
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'name', 'address', 'province_cod', 'province', 'nation_cod', 'nation', 'promotions_email', 'business_zone_cod', 'business_zone', 'payment_term_cod', 'payment_term', 'return_terms_cod', 'return_port_terms_cod', 'return_port', 'withdrawal_terms_cod', 'withdrawal_carrier_cod', 'withdrawar_carrier', 'shipping_address_cod', 'price_list_cod', 'vat_number', 'rating_cod'], 'safe'],
            [['postal_code', 'bank_credit_limit'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVCustomer::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'postal_code' => $this->postal_code,
            'bank_credit_limit' => $this->bank_credit_limit,
        ]);

        $query->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'address', $this->address])
            ->andFilterWhere(['like', 'province_cod', $this->province_cod])
            ->andFilterWhere(['like', 'province', $this->province])
            ->andFilterWhere(['like', 'nation_cod', $this->nation_cod])
            ->andFilterWhere(['like', 'nation', $this->nation])
            ->andFilterWhere(['like', 'promotions_email', $this->promotions_email])
            ->andFilterWhere(['like', 'business_zone_cod', $this->business_zone_cod])
            ->andFilterWhere(['like', 'business_zone', $this->business_zone])
            ->andFilterWhere(['like', 'payment_term_cod', $this->payment_term_cod])
            ->andFilterWhere(['like', 'payment_term', $this->payment_term])
            ->andFilterWhere(['like', 'return_terms_cod', $this->return_terms_cod])
            ->andFilterWhere(['like', 'return_port_terms_cod', $this->return_port_terms_cod])
            ->andFilterWhere(['like', 'return_port', $this->return_port])
            ->andFilterWhere(['like', 'withdrawal_terms_cod', $this->withdrawal_terms_cod])
            ->andFilterWhere(['like', 'withdrawal_carrier_cod', $this->withdrawal_carrier_cod])
            ->andFilterWhere(['like', 'withdrawar_carrier', $this->withdrawar_carrier])
            ->andFilterWhere(['like', 'shipping_address_cod', $this->shipping_address_cod])
            ->andFilterWhere(['like', 'price_list_cod', $this->price_list_cod])
            ->andFilterWhere(['like', 'vat_number', $this->vat_number])
            ->andFilterWhere(['like', 'rating_cod', $this->rating_cod]);

        return $dataProvider;
    }
}
