<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use bitcream\gmvricambi\custom\common\models\GMVArticlePriceList;
use yii\behaviors\SluggableBehavior;

/**
 * This is the model class for table "{{%order_item}}".
 *
 */
class OrderItem extends \bitcream\gmvricambi\custom\common\models\OrderItem
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            [
                'class' => SluggableBehavior::class,
                'attribute' => 'name',
                'slugAttribute' => 'slug',
            ]
        ]);
    }

    public function addOrderItem($articleCod, $orderItemPost, $plantCode = NULL){
        
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);        
        $order = Order::findOne($customerUser->getActiveOrder()->id);

        $language = $customerUser->customer->language;
        $products = Product::find()->where(['article_cod' => $articleCod, 'status' => '30'])->all();
        if(!empty($products)){
            if(!empty($language)){
                $productTranslated = Language::getTranslation($language, $products); 
            }
        }
        $priceListCod = GMVArticlePriceList::currentUserArticlePrices($articleCod)->price_list_cod;
        $GMVArticle = GMVArticle::findOne($articleCod);
        $orderItem = OrderItem::searchOrderItem($articleCod, $order, $plantCode);
        if((!$orderItem || (!empty($orderItemPost['dimension']))) || ($orderItem && $orderItem->plant_code != $plantCode)){
            $orderItem = new OrderItem();
            $orderItem->name = (isset($productTranslated))? $productTranslated->name : $GMVArticle->description;
            $orderItem->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $orderItem->name)));
            $orderItem->plant_code = $plantCode;
            $orderItem->product_price = $GMVArticle->price;
            $orderItem->family = $GMVArticle->family;
            $orderItem->discount_1 = $GMVArticle->discount1;
            $orderItem->discount_2 = $GMVArticle->discount2;
            $orderItem->discount_3 = $GMVArticle->discount3;
            $orderItem->discount_4 = $GMVArticle->discount4;
            $orderItem->discount_5 = $GMVArticle->discount5;
            $orderItem->price_list_cod = (!empty($priceListCod) || $priceListCod == "0")? $priceListCod: "";
            $orderItem->quantity = (float)$orderItemPost['quantity'];            
            $orderItem->dimension = (!empty($orderItemPost['dimension']))? (float)$orderItemPost['dimension'] : NULL;
            $orderItem->orderitem_status = "30";
            $orderItem->order_id = $customerUser->getActiveOrder()->id;            
            $orderItem->article_cod = $GMVArticle->article_cod;
        }else{
            $orderItem->quantity = $orderItem->quantity + (float)$orderItemPost['quantity'];
            $orderItem->price_list_cod = (!empty($priceListCod) || $priceListCod == "0")? $priceListCod: "";
        }
        $orderItem->total_price = $orderItem->total_price + $orderItem->product_price;
        $resultSave = $orderItem->save();
        $result = [
            "result" => $resultSave,
        ];
        return $result;
    }

    public function updateQuantityOrder(){        
        if(isset($orderItem['dimension'])){
            $this->dimension = $orderItem['dimension'];
        }
        if(isset($orderItem['quantity'])){
            $this->quantity = $orderItem['quantity'];
        }                
        if(isset($orderItem['plant_code'])){
            $this->plant_code = $orderItem['plant_code'];
        }
        if(isset($orderItem['note'])){
            $this->note = $orderItem['note'];
        }  
        return $this->save();         
    }
}
