<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'gmv-article-price-list-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Article cod'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->article_cod, [Yii::$app->controller->id.'/view','price_list_cod'=>$data->price_list_cod, 'customer_cod'=>$data->customer_cod, 'article_cod'=>$data->article_cod]);}
                ],
                'customer_cod',
                'price_list_cod',
                'quantity',
                'price',
                'discount_1',
                'discount_2',
                'discount_3',
                'discount_4',
                'discount_5'
                // [
                //     'class' => '\yii\grid\ActionColumn',
                //     'header' => Yii::t('gmv', 'Actions'),
                //     'visibleButtons' => ['delete' => false, 'update' => false, 'view' => true],
                // ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>