<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\ProductImage */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Product Images'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="product-image-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('gmv', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('gmv', 'Delete'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('gmv', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>
    <div class="row">
        <?php if($productImage){ ?>
            <div class="col-md-6 col-xs-12">
                <img src="<?=$productImage->image?>" class="img-responsive">
            </div>
            <div class="col-md-6 col-xs-12">
        <?php  }else{ ?>
            <div class="col-md-12 col-xs-12">
        <?php  } ?>

        <?= DetailView::widget([
            'model' => $model,
            'attributes' => [
                'id',
                'product_id',
                'image_id',
                'image:ntext',
                'status',
                'created_at',
                'created_user_id',
                'updated_at',
                'updated_user_id',
            ],
        ]) ?>
        </div>
    </div>

</div>
