<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMV_article}}".
 *
 */
class GMVArticle extends base\GMVArticle
{

    private $_price;
    private $_discount_1;
    private $_discount_2;
    private $_discount_3;
    private $_discount_4;
    private $_discount_5;

    public function getPrice(){
        $this->calculatePrice();
        return $this->_price;
    }
    public function getDiscount1(){
        return $this->_discount_1;
    }
    public function getDiscount2(){
        return $this->_discount_2;
    }
    public function getDiscount3(){
        return $this->_discount_3;
    }
    public function getDiscount4(){
        return $this->_discount_4;
    }
    public function getDiscount5(){
        return $this->_discount_5;
    }

    public function calculateDiscount1($articlePrice, $customerCod, $familyDiscount){
        if($articlePrice->customer_cod==$customerCod){
            $this->_discount_1 = $articlePrice->discount_1;
            return $articlePrice->discount_1;
        }
        if($familyDiscount){
            $this->_discount_1 = $familyDiscount->discount_1;
            return $familyDiscount->discount_1;
        }
        $this->_discount_1 = $articlePrice->discount_1;
        return $articlePrice->discount_1;
    }

    public function calculateDiscount2($articlePrice, $customerCod, $familyDiscount){
        if($articlePrice->customer_cod==$customerCod){
            $this->_discount_2 = $articlePrice->discount_2;
            return $articlePrice->discount_2;
        }
        if($familyDiscount){
            $this->_discount_2 = $familyDiscount->discount_2;
            return $familyDiscount->discount_2;
        }
        $this->_discount_2 = $articlePrice->discount_2;
        return $articlePrice->discount_2;
    }

    public function calculateDiscount3($articlePrice, $customerCod, $familyDiscount){
        if($articlePrice->customer_cod==$customerCod){
            $this->_discount_3 = $articlePrice->discount_3;
            return $articlePrice->discount_3;
        }
        if($familyDiscount){
            $this->_discount_3 = $familyDiscount->discount_3;
            return $familyDiscount->discount_3;
        }
        $this->_discount_3 = $articlePrice->discount_3;
        return $articlePrice->discount_3;
    }

    public function calculateDiscount4($articlePrice, $customerCod, $familyDiscount){
        if($articlePrice->customer_cod==$customerCod){
            $this->_discount_4 = $articlePrice->discount_4;
            return $articlePrice->discount_4;
        }
        if($familyDiscount){
            $this->_discount_4 = $familyDiscount->discount_4;
            return $familyDiscount->discount_4;
        }
        $this->_discount_4 = $articlePrice->discount_4;
        return $articlePrice->discount_4;
    }

    public function calculateDiscount5($articlePrice, $customerCod, $familyDiscount){
        if($articlePrice->customer_cod==$customerCod){
            $this->_discount_5 = $articlePrice->discount_5;
            return $articlePrice->discount_5;
        }
        if($familyDiscount){
            $this->_discount_5 = $familyDiscount->discount_5;
            return $familyDiscount->discount_5;
        }
        $this->_discount_5 = $articlePrice->discount_5;
        return $articlePrice->discount_5;
    }

    public function calculatePrice(){

        $priceListCod = '0';
        $articlePrice = GMVArticlePriceList::currentUserArticlePrices($this->article_cod);
        if(empty($articlePrice)) { //if user can buy that product we mark it with a develop price;
            $this->_price = 987654;
            return;
        }

        $customerCod = CustomerUser::getCurrentUser()->customerCod;

        $familyDiscount = GMVArticleFamilyDiscount::currentUserFamilyDiscount($this->family);

        $this->_price = (float)$articlePrice->price;
        $this->addDiscount($this->calculateDiscount1($articlePrice, $customerCod, $familyDiscount));
        $this->addDiscount($this->calculateDiscount2($articlePrice, $customerCod, $familyDiscount));
        $this->addDiscount($this->calculateDiscount3($articlePrice, $customerCod, $familyDiscount));
        $this->addDiscount($this->calculateDiscount4($articlePrice, $customerCod, $familyDiscount));
        $this->addDiscount($this->calculateDiscount5($articlePrice, $customerCod, $familyDiscount));
        return;
    }

    public function addDiscount( float $discount){
        if($discount ==  99) return;

        $this->_price = $this->_price * (1 - $discount/100);
        return;
    }

    /**
     * @inheritdoc$primaryKey
     */
    public static function primaryKey()
    {
        return ["article_cod"];
    }

    public function isDynamicDimension(){
        return ($this->unit_of_measure_cod != Yii::$app->params['paramsQuantityProduct'])? "true": "false";
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(GMVArticlesCategory::className(), ['subcomponent_cod' => 'subcomponent_cod']);
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public static function getPlantsCodes($article_cod)
    {
        $plantsCodes = GMVSparePartsForOrder::find()
                            ->select('*')
                            ->where([
                                        'article_cod' => $article_cod,
                                        'order_reference' => '',
                                    ])
                            ->all();
        return $plantsCodes;
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public static function getPlantsCodesModal($article_cod)
    {
        $arrayPlant = array();
        $plantsCodes = GMVSparePartsForOrder::find()
                            ->select('plant_cod')
                            ->where([
                                        'article_cod' => $article_cod,
                                        'order_reference' => '',
                                    ])
                            ->all();
        foreach($plantsCodes as $plantsCode){
            array_push($arrayPlant, $plantsCode['plant_cod']);
        }
        return $arrayPlant;
    }

    public function checkAvailability(){
        $availability = "";
        if($this->lead_time <= 5){
            return "<span class='label label-success label-availability'>".Yii::t('gmv', 'Immediate availability')."</span>";
        }else{
            $availability = "<span class='label label-warning label-availability'>";
            if($this->availability != "0.00"){
                $availability .= Yii::t('gmv', 'Pieces available {number}. ', ['number' => (int)$this->availability]);
            }
            $availability .= Yii::t('gmv', 'Available in {days} days from the date of the order', ['days' => $this->lead_time]);
            $availability .= "</span>";
        }
        return $availability;
    }

}
