<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMVShippingCost}}".
 *
 */
class GMVShippingCost extends base\GMVShippingCost
{
    /**
     * @inheritdoc $primaryKey
     */
    public static function primaryKey()
    {
        return ["zone_cod", "forwarder_cod"];
    }

    public static function findFirstGreater(float $weight, int $shippingZone, string $shipmentType = NULL){
        return GMVShippingCost::findByZone($shippingZone,$shipmentType)
                            ->andWhere(['>', 'weight', $weight])
                            ->orderBy('weight ASC')
                            ->one();
    }

    public static function findFirstLower(float $weight, int $shippingZone, string $shipmentType = NULL){
        return GMVShippingCost::findByZone($shippingZone,$shipmentType)
                            ->andWhere(['<', 'weight', $weight])
                            ->orderBy('weight DESC')
                            ->one();
    }

    public static function findByZone(int $shippingZone, string $shipmentType = NULL){
        return GMVShippingCost::find()
                    ->where([
                        'shipment_type' => $shipmentType,
                        'zone_cod' => $shippingZone,
                    ]);
    }

    public function getCalculateTotal(){
        return $this->shipment_cost + $this->extra_cost_zone + $this->insurance;  
    }

    public function getCalculateExceeded($weightExceeded){
        return ($weightExceeded * $this->gmv_markup) + ($weightExceeded * $this->extra_max_weight);        
    }

}
