<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_article_price_list}}".
 *
 * @property string $price_list_cod
 * @property string $customer_cod
 * @property string $article_cod
 * @property float|null $quantity
 * @property float|null $price
 * @property float|null $discount_1
 * @property float|null $discount_2
 * @property float|null $discount_3
 * @property float|null $discount_4
 * @property float|null $discount_5
 * @property string|null $currency
 */
class GMVArticlePriceList extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        // use the "db2" application component
        return \Yii::$app->gmv;  
    }
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_article_price_list}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['price_list_cod', 'customer_cod', 'article_cod'], 'required'],
            [['quantity', 'price', 'discount_1', 'discount_2', 'discount_3', 'discount_4', 'discount_5'], 'number'],
            [['price_list_cod'], 'string', 'max' => 1],
            [['customer_cod'], 'string', 'max' => 6],
            [['article_cod'], 'string', 'max' => 15],
            [['currency'], 'string', 'max' => 3],
            [['price_list_cod', 'customer_cod', 'article_cod'], 'unique', 'targetAttribute' => ['price_list_cod', 'customer_cod', 'article_cod']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'price_list_cod' => Yii::t('gmv', 'Price List Cod'),
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'article_cod' => Yii::t('gmv', 'Article Cod'),
            'quantity' => Yii::t('gmv', 'Quantity'),
            'price' => Yii::t('gmv', 'Price'),
            'discount_1' => Yii::t('gmv', 'Discount 1'),
            'discount_2' => Yii::t('gmv', 'Discount 2'),
            'discount_3' => Yii::t('gmv', 'Discount 3'),
            'discount_4' => Yii::t('gmv', 'Discount 4'),
            'discount_5' => Yii::t('gmv', 'Discount 5'),
            'currency' => Yii::t('gmv', 'Currency'),
        ];
    }
}
