<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_province}}".
 *
 * @property string $province_cod
 * @property string|null $description
 */
class GMVProvince extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        return \Yii::$app->gmv;  
    }
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_province}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['province_cod'], 'required'],
            [['province_cod'], 'string', 'max' => 5],
            [['description'], 'string', 'max' => 50],
            [['province_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'province_cod' => Yii::t('gmv', 'Province Cod'),
            'description' => Yii::t('gmv', 'Description'),
        ];
    }
}
