<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMVArticlePriceList}}".
 *
 */
class GMVArticlePriceList extends base\GMVArticlePriceList
{
    public static function currentUserArticlePrices($articleCod, $priceListCod = null){
        $customerUser = CustomerUser::getCurrentUser();
        $customerCod = $customerUser->customerCod;
        return self::userArticlePrices($customerUser->customer, $customerCod, $articleCod, $priceListCod);
    }
    public static function userArticlePrices($gmvCustomer, $customerCod, $articleCod, $priceListCod = "0"){
        if(isset($gmvCustomer->price_list_cod)){
            $priceListCod = $gmvCustomer->price_list_cod;
        }

        $articlePrice = GMVArticlePriceList::find()
                            ->where([
                                        'price_list_cod' => $priceListCod,
                                        'article_cod' => $articleCod,
                                        'customer_cod' => [$customerCod, '**']
                                    ])
                            ->orderBy(['customer_cod' => SORT_DESC])
                            ->one();

        // foreach($articlePrices as $articlePrice){
        //     $selectedArticlePrice = $articlePrice;
        // }
        return $articlePrice;
    }

    public static function currentUserArticlesCod($priceListCod = null){
        $customerUser = CustomerUser::getCurrentUser();
        $customerCod = $customerUser->customerCod;
        return self::userArticlesCod($customerUser->customer, $customerCod, $priceListCod);
    }
    public static function userArticlesCod($gmvCustomer, $customerCod, $priceListCod = "0"){
        $articleList = array();
        if(isset($gmvCustomer->price_list_cod)){
            $priceListCod = $gmvCustomer->price_list_cod;
        }

        $articles = GMVArticlePriceList::find()
                            ->select('article_cod')
                            ->where([
                                        'price_list_cod' => $priceListCod,
                                        'customer_cod' => [$customerCod, '**']
                                    ])
                            ->distinct()
                            ->all();

        foreach($articles as $article){
            array_push($articleList, $article);
        }
        
        return $articleList;
    }

    public static function filterCurrentUserArticle(&$query, $priceListCod = null){
        $customerUser = CustomerUser::getCurrentUser();
        self::filterUserArticle($query, $customerUser->customer, $customerUser->customerCod, $priceListCod);
    }

    public static function filterUserArticle(&$query, $gmvCustomer, $customerCod, $priceListCod = "0"){
        if(isset($gmvCustomer->price_list_cod)){
            $priceListCod = $gmvCustomer->price_list_cod;
        }

        $query->innerJoin('GMV_article_price_list', 'GMV_article_price_list.article_cod = GMV_article.article_cod');
        $query->andWhere(
            [
                'price_list_cod' => $priceListCod,
                'customer_cod' => [$customerCod, '**']
            ]
        );
    }

}
