<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use Emberware\Evidia\Model\GotifySender\behaviors\SendNotification;
use bitcream\gmvricambi\custom\common\behaviors\OrderStatusBehaviors;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;
use bitcream\gmvricambi\custom\backend\models\OrderItem;
/**
 * This is the model class for table "{{%order}}".
 *
 */
class Order extends base\Order
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'send-notification' => [
                'class' => SendNotification::className(),
                'messageType' => [
                    'update' => 'orderUpdated',
                    'delete' => 'orderDeleted',
                    'create' => 'orderCreated',
                ],
                'messages' => [
                    ActiveRecord::EVENT_AFTER_UPDATE => 'orderUpdated',
                    ActiveRecord::EVENT_AFTER_INSERT => 'orderCreated',
                    ActiveRecord::EVENT_BEFORE_DELETE => 'orderDeleted',
                    OrderStatusBehaviors::EVENT_AFTER_ORDER_SEND => 'orderSent',
                    OrderStatusBehaviors::EVENT_AFTER_ORDER_ACTIVE => 'orderActivated',
                ]
            ],
            'order_status' => [
                'class' => OrderStatusBehaviors::className(),
            ],
        ]);
    }

    /**
     * Gets query for [[CustomerCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod']);
    }

    
    /** 
        * Gets query for [[CustomerCod]]. 
        * 
        * @return \yii\db\ActiveQuery 
        */ 
    public function getCustomerCod() 
    { 
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod']); 
    }

    public function updateTotal(){
        $this->total = 0;
        foreach($this->orderItems as $orderItem){
            $this->total = $this->total + $orderItem->total_price;
        }
        $this->save();
        return $this->total;
    }

    public function getTotal(){
        return $this->updateTotal();
    }

    public function getOrderItems(){
        return OrderItem::find()->where(['status' => '30', 'order_id' => $this->id])->all();
    }

    // public function addToTotal($total){        
    //     $this->total = $this->total + $total;
    //     $this->save();
    //     return $this->total;
    // }

    // public function removeToTotal($orderItem){        
    //     $this->total = $this->total - $orderItem->total_price;
    //     $this->save();
    //     return $this->total;
    // }

    /**
     * Controlla metodo pagamento:
     * - se coerente e validato cambia stato all'ordine
     */
    public function confirm($paymentMethodCod, $total, $shippingMethod, $shippingCost = 0, $nationCod){
        if(!$this->customer->checkPaymentMethod($paymentMethodCod, $total)) return false;
        
        $this->payment_method = $paymentMethodCod;        
        $this->confirm_date = time();
        $this->delivery_date = $this->setDeliveryDate($this->confirm_date);        
        if(GMVPaymentMethod::isInstantPayment($paymentMethodCod)){
            //TODO: if(!$this->isPayed) return false; //controlla che risulti pagato l'ordine
            $this->shipping_method = $shippingMethod;
            $this->payment_method = $paymentMethodCod;
            $this->confirm_date = time();
            $this->delivery_date = $this->setDeliveryDate($this->confirm_date);
            $this->save();
            return true;  
        }
        $this->shipping_method = $shippingMethod;
        $this->payment_method = $paymentMethodCod;        
        $this->confirm_date = time();
        $this->delivery_date = $this->setDeliveryDate($this->confirm_date);
        $this->save();
    }

    public function rules()
    {
        return [
            [['name'], 'required'],
           //[['shipping_address'], 'required', 'when' => function ($model) { return $model->address == ""; }, 'message' => 'Please choose a shipping address.'],
            [['province', 'address','locality', 'country'],'required', 'when' => function ($model) { return $model->shipping_address == ""; }, 'whenClient' => "function (attribute, value) { return $('#order-shipping_address').val() == '';}"],
            [['shipping_address'],'required', 'when' => function ($model) { return $model->address == ""; }, 'whenClient' => "function (attribute, value) { return $('#order-address').val() == '';}"]
            
        ];
    }

    
    public static function localityList($customerUser)
    {
        $localities['all']  = Yii::t('gmv', 'All destination');
        $orders = Order::find()->where(['customer_cod' => $customerUser->customerCod, 'order_status' => $customerUser->getOrdersStatusSelected()])->all();
        foreach($orders as $order){
            $localities[$order->locality] = $order->locality;            
        }
        return $localities;
    }

    public function duplicateOrder(){
        $copyOrder = clone $this;
        $copyOrder->isNewRecord = true;
        foreach ($this->getPrimaryKey(true) as $field => $value) {
            unset($copyOrder->{$field});
        }
        $copyOrder->name = Yii::t('gmv', 'Copy of')." ".$this->name;
        $copyOrder->order_date = (string)time();
        $copyOrder->order_status = "processing";
        $copyOrder->plant_reference = "";
        $copyOrder->status = "30";
        $copyOrder->created_at = (string)time();
        $copyOrder->updated_at = (string)time();
        $copyOrder->save();

        $orderItems = $this->orderItems;
        if(!empty($orderItems)){
            foreach($orderItems as $orderItem){
                $cloneOrderItem = new OrderItem;
                $cloneOrderItem->attributes = $orderItem->attributes;
                $cloneOrderItem->order_id = $copyOrder->id;
                $cloneOrderItem->created_at = (string)time();
                $cloneOrderItem->updated_at = (string)time();
                $cloneOrderItem->plant_code = "";
                $cloneOrderItem->save();    
            }
        }
        return $copyOrder;        
    }

    public function setDeliveryDate($date){
        $maxDay = 0;
        if(isset($this->orderItems)){
            foreach($this->orderItems as $orderItem){
                if(isset($orderItem->gmvArticle)){
                    if($orderItem->gmvArticle->lead_time > $maxDay){
                        $maxDay = $orderItem->gmvArticle->lead_time;
                    }
                }
            }
            $stringMaxDay = "+".$maxDay." days";
            return strtotime(date("Y-m-d H:i:s", $date) . $stringMaxDay);
        }
        return $date;
    }

    /**
     * Gets query for [[ShippingZone]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvShippingZone()
    {
        return $this->hasOne(GMVShippingZone::className(), [ 'country_cod' => 'country']);
    }

    /**
     * Gets query for [[ShippingZone]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvShippingAddress()
    {
        return $this->hasOne(GMVShippingAddress::className(), [ 'shipping_address_cod' => 'shipping_address']);
    }

    /**
     * se lo portano loro vanno a vedere country cod della nazione e identificano la zona di appartenenza zone_cod
     * in shipping cost hanno una struttura che varia a seconda del peso
     * vanno a vedere la zone_cod (esempio italia = zona 0 )
     * forwarder cod = solo a titolo informativo per il cliente 
     * si fa la somma di shipment_cost + extra cost + insurance 
     * 
     * non spediscono oltre i 100kg in Italia > se superano bisogna mettere un altro alert dicendo che bisogna fare in altro modo
     * 
     */
    public function calculateShippingCost(){
        $cost = $this->calculateShippingCostExtra();
        return $cost;
        // $cost = 0;
        // //prendo zona appartenenza da tabella shipping zone
        // $shippingZone = $this->gmvShippingZone;
        // //prendo tutti i costi di spedizione di quella zona
        // $shippingCosts = $shippingZone->gmvShippingCost;
        // //get order
        // foreach($this->orderItems as $orderItem){
        //     $weight = $this->weight();      
        //     foreach($shippingCosts as $shippingCost){
        //         if($weight <= $shippingCost->weight){
        //             $cost += $shippingCost->shipment_cost + $shippingCost->extra_cost_zone + $shippingCost->insurance;
        //             break;
        //         }
        //         if($weight > 100){
        //             return false;
        //         }
        //     }       
        // } 
        // return $cost;         
    }

    public function addShippingCost($cost){
        OrderItem::addShippingOrderItem($this, $cost);  
        return $cost; 
    }

    public function getFirstLowerShippingCost(){
        return GMVShippingCost::findFirstLower($this->weight(), $this->gmvShippingZone->zone_cod, $this->shipping_method);
    }

    public function getFirstGreaterShippingCost(){
        return GMVShippingCost::findFirstGreater($this->weight(), $this->gmvShippingZone->zone_cod, $this->shipping_method);
    }

    /** 
     * per gli altri paesi (ad esempio zona1) la riga dei 100kg ha una forma diversa (es. .00 in shipment_cost) puoi spedire oltre i 100 kg 
    * ma il calcolo è come se pesasse 70 kg (quindi somma dei tre campi) bisogna mettere supplemento + calcolo sui kg sopra i 100 (esempio 20) 
    * ci sarà da sommare ai 3 campi precedenti 20 x gmv_markup+20 x extra_max_weight
    * metteranno 999 o codice che definiscono, in questo caso noi prendiamo ultima acquisizione e aggiungiamo supplemento
    */
    public function calculateShippingCostExtra(){
        $cost = 0;
        $weight = $this->weight();         
        $shippingCost = $this->getFirstGreaterShippingCost();
        if($shippingCost->weight == "999999.00"){
            $lowerShippingCost = $this->getFirstLowerShippingCost();   
            $cost = $lowerShippingCost->getCalculateTotal();
            $cost += $shippingCost->getCalculateExceeded($weight - $lowerShippingCost->weight);
            return $cost;
        }
        $cost = $shippingCost->getCalculateTotal();
        return $cost;
    }

    public function canCalculateShipmentCost(){
        if(empty($this->gmvShippingZone)) return false;
        if(empty($this->gmvShippingZone->gmvShippingCost)) return false;
        if(empty($this->getFirstGreaterShippingCost())) return false;
        return true;
    }

    public function weight(){
        $weight = 0;
        foreach($this->orderItems as $orderItem){
            if($orderItem->name != "Shipping Cost"){
                if($orderItem->gmvArticle->unit_of_measure_cod == "MT"){
                    $weight += $orderItem->gmvArticle->weight * $orderItem->dimension;
                }else{
                    $weight += $orderItem->gmvArticle->weight * $orderItem->quantity;
                } 
            }
        }
        return $weight;
    }

    public function hasOverWeight(){
        return ($this->weight() >= 100);
    }

    public static function checkBulkyProduct($orderItems){
        $bulkyProducts = [];
        $message = "<p class='alert_message'>In the cart there are bulky items you will be contacted by GMV for a quote on the shipping costs of these items:<br>";
        foreach($orderItems as $orderItem){
            if($orderItem->name != "Shipping Cost"){
                if($orderItem->gmvArticle->quote_shipping == "1")
                    $bulkyProducts[] = $orderItem->gmvArticle->description;
            }            
        }
        if(!empty($bulkyProducts)){
            foreach($bulkyProducts as $bulkyProduct){
                $message.= $bulkyProduct."<br>";
            }
            return "</p>".$message;
        }
        return;
    }

    public function bulkyProducts(){
        $bulkyProducts = [];
        foreach($this->orderItems as $orderItem){
            if($orderItem->name == "Shipping Cost") continue;

            if($orderItem->gmvArticle->quote_shipping == "1")
                $bulkyProducts[] = $orderItem->gmvArticle->description;          
        }
        return $bulkyProducts;
    }

    public function hasBulkyProduct(){
        return count($this->bulkyProducts());
    }

    public function requiresManualShippingQuote(): bool{
        return ($this->hasOverWeight() || $this->hasBulkyProduct() || !$this->canCalculateShipmentCost());
    }

    public function canBeConfirmed(){
        if($this->order_status == "quoted") return true;
        if($this->requiresManualShippingQuote()) return false;
        return true;
    }

    public function getShippingCost(){
        if(!$this->requiresManualShippingQuote()){
            if(trim($this->nation) == "I"){
                if($this->shipping_term_cod == "02") return $this->addShippingCost(0);
                return $this->addShippingCost($this->calculateShippingCost());
            }             
            return $this->addShippingCost($this->calculateShippingCostExtra());
        }
        return $this->getShippingCostOrderItem();      
    }

    public function getShippingCostOrderItem(){
        foreach($this->orderItems as $orderItem){
            if($orderItem->name == "Shipping Cost") 
                return $orderItem->product_price;         
        }
        return 0;
    }

    public function getNationCod(){
        return $this->customer->nation_cod;
    }

    public function setShippingTerm(){
        if($this->shipping_term == "01"){
            if(trim($this->nation) != "I"){ 
                $this->shipping_term_cod = "18";      
                $this->save();
                return;          
            }
        }
        $this->shipping_term_cod = $this->shipping_term;
        $this->save();
        return;
    }

    public function getNation(){
        if(isset($this->gmvShippingAddress->nation)) return $this->gmvShippingAddress->nation;
        return $this->country;
    }

    public function getShippingMethod(){
        if($this->shipping_method == "G") return Yii::t('gmv','Ground shipping');
        if($this->shipping_method == "A") return Yii::t('gmv','Shipping by air');
        return "";
    }

    public function getCountry(){
        $country = GMVCountry::findOne(['country_cod' => $this->country]);
        return $country->description;
    }

    public function getShippingAddress(){
        if(!empty($this->shipping_address)){
            $shippingAddress = GMVShippingAddress::findOne(['shipping_address_cod' => $this->shipping_address, 'customer_cod' => $this->customer_cod]);
            return $shippingAddress->business_name_address." - ".$shippingAddress->address." ".$shippingAddress->locality." ".$shippingAddress->postal_code." ".$shippingAddress->province." ".$shippingAddress->nation;
        }
        return $this->business_name." - ".$this->address." ".$this->locality." ".$this->postal_code." ".$this->province." ".$this->getCountry();
    }
}
