<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVCustomer;
use bitcream\gmvricambi\custom\backend\models\GMVCustomerSearch;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * GmvCustomerController implements the CRUD actions for GMVCustomer model.
 */
class GmvCustomerController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVCustomer models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVCustomerSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVCustomer model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($customer_cod)
    {
        return $this->render('view', [
            'model' => $this->findModel($customer_cod),
        ]);
    }

    /**
     * Creates a new GMVCustomer model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVCustomer();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->customer_cod]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVCustomer model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->customer_cod]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVCustomer model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVCustomer model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return GMVCustomer the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GMVCustomer::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }

     /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionBusinessInfo()
    {
        // Yii::$app->user->id;
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        return $this->render('business_info', [
            'model' => $this->findModel($customerUser->customerCod),            
        ]);
    }

    /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionPaymentInfo()
    {
        // Yii::$app->user->id;
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        return $this->render('payment_info', [
            'model' => $this->findModel($customerUser->customerCod),
        ]);
    }

    /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionContactUs()
    {
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        return $this->render('contact-us', [
            'model' => $this->findModel($customerUser->customerCod),
            'customerUser' => $customerUser,
        ]);
    }

    public function actionSendEmail(){
        $model = new GMVCustomer();
        if(Yii::$app->request->post()){
            if ($model->sendEmail(Yii::$app->request->post())) {
                Yii::$app->session->setFlash('success', 'Email correctly sent!');

                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Sorry, an error occurred while sending the e-mail!');
            }
        }
    }
}
