<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;
use bitcream\gmvricambi\custom\common\behaviors\LanguageBehaviors;
use yii\behaviors\SluggableBehavior;

/**
 * This is the model class for table "{{%category}}".
 *
 */
class Category extends \bitcream\gmvricambi\custom\common\models\Category
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'language' => [
                'class' => LanguageBehaviors::className(),
                'langs' => [
                    'it',
                    'en',
                    'de',
                ],
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            [
                'class' => SluggableBehavior::class,
                'attribute' => 'name',
                'slugAttribute' => 'slug',
            ],
        ]);
    }

    
}
