<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;
use bitcream\gmvricambi\custom\backend\models\ProductImage;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            'filterModel' => $searchModel,
            //'searchModel' => $searchModel,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Article cod'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->article_cod, [Yii::$app->controller->id.'/view','article_cod'=>$data->article_cod]);}
                ],
                'assembled_product',
                [
                    'attribute' => Yii::t('gmv', 'Category'),
                    'value' => 'category.name'
                ],
                'assembled_product',
                 [
                    'format'=>'raw',
                    'label' => Yii::t('gmv', 'Actions'),
                    'value' => function ($model, $key, $index, $column) use ($languages)
                    {
                        $arrLang = array();
                        //Get product with article_cod
                        $htmlButtons = "";
                        // $model->products;
                        $productImage = ProductImage::find()->where(['article_cod' => $model->article_cod])->one();
                        if(!isset($productImage->article_cod)){
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-plus"></i> <i class="fa fa-picture-o"></i>'), ['product-image/create', 'article' => $model->article_cod, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-primary action-button']);
                        }else{
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-pencil"></i> <i class="fa fa-picture-o"></i>'), ['product-image/update', 'article' => $model->article_cod, 'id'=> $productImage->id, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-primary action-button']);
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-trash-o"></i> <i class="fa fa-picture-o"></i>'), ['product-image/delete', 'id'=> $productImage->id, 'controller'=>Yii::$app->controller->id], [
                                'class' => 'btn btn-danger action-button',
                                'data' => [
                                    'confirm' => Yii::t('gmv','Are you sure you want to delete this product image?'),
                                    'method' => 'post',
                                ]
                            ]);
                        }

                        if($model->products){
                            foreach($model->products as $product){
                                $lang = $product->getLanguageObject();
                                if($lang){
                                    if($lang->label == "en"){
                                        $country = "gb";
                                    }else{
                                        $country = $lang->label;
                                    }
                                    $flag = FlagIcon::widget([
                                        'countryCode' => $country,
                                        'options' => [
                                            'class' => 'flag-button'
                                        ]                            
                                    ]);

                                    array_push($arrLang, $lang->label);
                                    
                                    $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-pencil"></i>', ['flag' => $flag]), ['product/update', 'id' => $product->id, 'article' => $model->article_cod], ['class' => 'btn btn-warning action-button']);
                                    $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-trash-o"></i>', ['flag' => $flag]), ['product/delete', 'id'=> $product->id, 'controller'=>Yii::$app->controller->id], 
                                        [
                                            'class' => 'btn btn-danger action-button',
                                            'data' => [
                                                'confirm' => Yii::t('gmv','Are you sure you want to delete this product?'),
                                                'method' => 'post',
                                            ]
                                        ]);
                                }
                            }
                        }

                        foreach($languages as $language) 
                        {
                            if (!in_array($language, $arrLang)) {
                                if($language == "en"){
                                    $country = "gb";
                                }else{
                                    $country = $language;
                                }
                                $flag = FlagIcon::widget([
                                    'countryCode' => $country,
                                    'options' => [
                                        'class' => 'flag-button'
                                    ]                            
                                ]);
                                $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-plus"></i>', ['flag' => $flag]), ['product/create', 'lang_create' => $language, 'article' => $model->article_cod], ['class' => 'btn btn-success action-button']);
                            }
                        }

                        return $htmlButtons;
                       
                    }
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>