<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\OrderActionWidget;
use yii\bootstrap\Modal;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
bitcream\gmvricambi\custom\backend\Asset::register($this);
$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php
        echo OrderActionWidget::widget(['status' => $status, 'model' => $model, 'activeOrder' => $customerUser->getActiveOrder(), 'categoryMessage' => 'gmv']);
    ?>

    <?php if((!empty($model->orderItems) && $rating) || $model->hasBulkyProduct()){        
            echo $this->render('_modal_confirm',[
                'model' => $model,
                'paymentMethods' => $paymentMethods,
            ]);
        }elseif(!$rating){
            echo $this->render('_modal_nosent');
        }else{
            echo $this->render('_modal_empty');
    }
    ?>

    <?php
    if($model->hasBulkyProduct() && $model->order_status != "quoted" && $model->shipping_term != "02"){?>
        <p class="alert_message"><?=Yii::t('gmv','ATTENTION! The cart contains at least one item for which a specific quotation of the shipping costs is required: GMV will be responsible for contacting you to provide you with an estimate of the shipping costs.')?></p>
    <?php
    }
    ?>

    <?php if($model->hasOverWeight() && $model->order_status != "quoted" && $model->shipping_term != "02"){?>
        <div class='row'>
            <div class='col-md-12'>
            <p class="alert_message"><?=Yii::t('gmv','ATTENTION! Overweight')?></p>
            </div>
        </div>
    <?php } ?>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            [
                'label'  => Yii::t('gmv','Order date'),
                'value'  =>  date("d/m/Y", $model->order_date)
            ],
            'business_name',
            'address',
            'locality',
            'postal_code',
            [
                'label'  => Yii::t('gmv','Country'),
                'value'  => (!empty($model->country))? $model->getCountry(): "" 
            ],
            [
                'label'  => Yii::t('gmv','Shipping address'),
                'value'  => $model->getShippingAddress()
            ],
            [
                'label'  => Yii::t('gmv','Shipping method'),
                'value'  => $model->getShippingMethod()
            ],
            [
                'label'  => Yii::t('gmv','Delivery date'),
                'value'  =>  (!empty($model->delivery_date))? date('d/m/Y', $model->delivery_date): ""
            ],
            'payment_method',
            'customer_cod',
            'order_status',
            'total',
            [
                'label'  => Yii::t('gmv','Plant reference'),
                'value'  =>  (!empty($model->plant_reference))? json_encode(unserialize($model->plant_reference)) : Yii::t('gmv','Missing plant code'),
                'contentOptions' => ['class' => (empty($model->plant_reference))? 'plant_message': ''],
            ],
            'courier_subscription_code',
            [
                'label'  => Yii::t('gmv','Confirm date'),
                'value'  => (!empty($model->confirm_date))? date("d/m/Y", $model->confirm_date): "" 
            ],
        ],
    ]) ?>
    <br>
    <hr>

    <?php if($model->checkProcessing()){ 
            if(isset($customerUser->getActiveOrder()->id) && ($customerUser->getActiveOrder()->id  == $model->id)){ 
                echo Html::a(Yii::t('gmv','Add products to order'), ['gmv-article-customer/index'], ['class' => 'btn btn-success']);
            }else{
                echo Html::a(Yii::t('gmv','Add products to order'), ['activate-add-product-order', 'id' => $model->id], ['class' => 'btn btn-success']);
            }
        } ?>
    <?= $this->render('_datatable-orderitem',[
            'searchModel' => $searchModelOrderItem,
            'dataProvider' => $dataProviderOrderItem,
            'order' => $model,
    ]) ?>
    

</div>
