<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'orderitem-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'article_cod',
                'name',
                [
                    'attribute'=>Yii::t('gmv', 'Quantity'),
                    'format'=>'raw',
                    'value' => function($data)
                    {
                        if(!empty($data->dimension)){
                            return $data->quantity."x".$data->dimension." ".$data->gmvArticle->unit_of_measure_cod;
                        }
                        return $data->quantity;
                    }
                ],
                'product_price',
                'plant_code',
                // [
                //     'class' => '\yii\grid\ActionColumn',
                //     'header' => Yii::t('gmv', 'Actions'),
                //     'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                // ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>