<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\datecontrol\DateControl;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="order-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <?=Html::button(Yii::t('gmv', 'New shipping address'), ['class' => 'btn btn-primary button-shipping']);?>
            <input type="hidden" id="new-address" name="new-address" value="0">
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'shipping_address')->widget(Select2::classname(), [
                'name' => 'shipping_address',
                'class' => 'form-group shipping_address_ids form-control',
                'value' => ArrayHelper::map($shippingAddress, 'shipping_address_cod', function ($shippingAddress) {                    
                    return $shippingAddress['business_name_address']." - ".$shippingAddress['address']." - ".$shippingAddress['locality']." - ".$shippingAddress['postal_code']." - ".$shippingAddress['province'];
                }),
                'id' => 'shipping_address_ids',
                'data' => ArrayHelper::map($shippingAddress, 'shipping_address_cod', function ($shippingAddress) {
                    return $shippingAddress['business_name_address']." - ".$shippingAddress['address']." - ".$shippingAddress['locality']." - ".$shippingAddress['postal_code']." - ".$shippingAddress['province'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('gmv', 'Select shipping address')]
            ]);?>
        </div>
        
    </div>
    <div class="row order-business-name">
        <div class="col-md-6">
            <?= $form->field($model, 'business_name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row order-address">
        <div class="col-md-6">
            <?= $form->field($model, 'address')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row order-locality">
        <div class="col-md-6">
            <?= $form->field($model, 'locality')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row order-province">
        <div class="col-md-6">
            <?= $form->field($model, 'province')->widget(Select2::classname(), [
                'name' => 'province',
                'class' => 'form-group province_ids form-control',
                'value' => ArrayHelper::map($provinces, 'province_cod', function ($province) {
                    return $province['province_cod'];
                }),
                'id' => 'province',
                'data' => ArrayHelper::map($provinces, 'province_cod', function ($province) {
                    return $province['description'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('gmv', 'Select province')]
            ]);?>
        </div>
    </div>

    <div class="row order-postal_code">
        <div class="col-md-6">
            <?= $form->field($model, 'postal_code')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row order-country">
        <div class="col-md-6">
            <?=  $form->field($model, 'country')->widget(Select2::classname(), [
                'name' => 'country',
                'class' => 'form-group country_ids form-control',
                'value' => ArrayHelper::map($countries, 'country_cod', function ($country) {
                    return $country['country_cod'];
                }),
                'id' => 'country',
                'data' => ArrayHelper::map($countries, 'country_cod', function ($country) {
                    return $country['description'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('gmv', 'Select country')]
            ]);?>
        </div>
    </div>    
    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <label class="control-label"><?=Yii::t('app','Delivery methods')?></label>
            <?= Select2::widget([
                'name' => 'Order[shipping_term]',
                'id' => 'shipping_term',
                'data' => [
                    '02' => Yii::t('app',"Ritiro cliente c/o GMV Stabilimento di Novara (porto assegnato)"),
                    '01' => Yii::t('app',"Spedizione a mezzo corriere direttamente presso indirizzo fornito dal cliente (porto franco/DAP) - Italia"), 
                    '18' => Yii::t('app',"Spedizione a mezzo corriere direttamente presso indirizzo fornito dal cliente (porto franco/DAP) - CEE/EXTRACEE"),                     
                ],
                'value' => $model->shipping_term,
                'options' => [
                    'placeholder' => Yii::t('app','Select a delivery methods ...'),
                ],
            ]);?><br>
        </div>
    </div>
    <div class="row order_courier_subscription_code">
        <div class="col-md-6">
            <?= $form->field($model, 'courier_subscription_code')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <hr>
    <!-- <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'delivery_date')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'order_reference')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'plant_reference')->textInput(['maxlength' => true]) ?>
        </div>
    </div> -->
    <div class="form-group">
        <?= Html::submitButton(Yii::t('gmv', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
