<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\ProductComponent */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-component-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'short_label')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'x_position')->textInput() ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'y_position')->textInput() ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'article_cod')->hiddenInput(['value'=> $gmvAssembledArticle->article_cod])->label(false); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'category_id')->widget(Select2::classname(), [
                'name' => 'category_id',
                'class' => 'form-group category_ids form-control',
                'value' => ArrayHelper::map($categories, 'id', function ($category) {                    
                    return $category['name'];
                }),
                'id' => 'category_ids',
                'data' => ArrayHelper::map($categories, 'id', function ($category) {
                    return $category['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('gmv', 'Select category')]
            ]);?>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton(Yii::t('gmv', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
