<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Product */

$this->title = Yii::t('gmv', 'Update Product: {name}', [
    'name' => $model->name,
]);
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Products'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->name, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('gmv', 'Update');
?>
<div class="product-update">

    <h1><?=Yii::t('gmv','GMV Article details')?></h1>
    <?= DetailView::widget([
        'model' => $gmvArticle,
        'attributes' => [
            'article_cod',
            'description',
            'family',
            'unit_of_measure_cod',
            'unit_of_measure',
            'weight',
            'packaging_code',
            'assembled_product',
        ],
    ]) ?>

    <hr>

    <h1><?= Html::encode($this->title) ?></h1>

    <?= $this->render('_form', [
        'model' => $model,
        'gmvArticle' => $gmvArticle
    ]) ?>

</div>
