<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMVAssembliesParts}}".
 *
 */
class GMVAssembliesParts extends base\GMVAssembliesParts
{
    /**
     * @inheritdoc$primaryKey
     */
    public static function primaryKey()
    {
        return ["PartName"];
    }

    /**
     * Gets query for [[ArticleCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvAssemblies()
    {
        return $this->hasOne(GMVAssemblies::className(), ['AssemblyID' => 'Assembly_ID']);
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvAssembliesPartsArticles()
    {
        return $this->hasMany(GMVAssembliesPartsArticles::className(), ['IDPart' => 'Assembly_Part']);
    }
}
