<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_order_other}}".
 *
 * @property string $plant_cod
 * @property string|null $order_reference
 * @property string|null $plant_reference
 * @property string|null $plant_type
 * @property string|null $order_confirmation_date
 * @property string|null $customer_cod
 * @property string $order_status
 */
class GMVOrderOther extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        return \Yii::$app->gmv;  
    }
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_order_other}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['plant_cod', 'order_status'], 'required'],
            [['order_confirmation_date'], 'safe'],
            [['plant_cod'], 'string', 'max' => 10],
            [['order_reference', 'plant_reference'], 'string', 'max' => 25],
            [['plant_type', 'order_status'], 'string', 'max' => 20],
            [['customer_cod'], 'string', 'max' => 6],
            [['plant_cod', 'order_status'], 'unique', 'targetAttribute' => ['plant_cod', 'order_status']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'plant_cod' => Yii::t('gmv', 'Plant Cod'),
            'order_reference' => Yii::t('gmv', 'Order Reference'),
            'plant_reference' => Yii::t('gmv', 'Plant Reference'),
            'plant_type' => Yii::t('gmv', 'Plant Type'),
            'order_confirmation_date' => Yii::t('gmv', 'Order Confirmation Date'),
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'order_status' => Yii::t('gmv', 'Order Status'),
        ];
    }
}
