<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%order_item}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M210820124520AddProductIdColumnToOrderItemTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%order_item}}', 'product_id', $this->integer()->null());

        // creates index for column `product_id`
        $this->createIndex(
            '{{%idx-order_item-product_id}}',
            '{{%order_item}}',
            'product_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-order_item-product_id}}',
            '{{%order_item}}',
            'product_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-order_item-product_id}}',
            '{{%order_item}}'
        );

        // drops index for column `product_id`
        $this->dropIndex(
            '{{%idx-order_item-product_id}}',
            '{{%order_item}}'
        );

        $this->dropColumn('{{%order_item}}', 'product_id');
    }
}
