<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%order_item}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%GMV_Article}}`
 */
class M210924130612AddArticleCodColumnToOrderItemTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%order_item}}', 'article_cod', $this->string(15)->null());

        // creates index for column `article_cod`
        $this->createIndex(
            '{{%idx-order_item-article_cod}}',
            '{{%order_item}}',
            'article_cod'
        );

        // add foreign key for table `{{%GMV_Article}}`
        $this->addForeignKey(
            '{{%fk-order_item-article_cod}}',
            '{{%order_item}}',
            'article_cod',
            '{{%GMV_Article}}',
            'article_cod',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%GMV_Article}}`
        $this->dropForeignKey(
            '{{%fk-order_item-article_cod}}',
            '{{%order_item}}'
        );

        // drops index for column `article_cod`
        $this->dropIndex(
            '{{%idx-order_item-article_cod}}',
            '{{%order_item}}'
        );

        $this->dropColumn('{{%order_item}}', 'article_cod');
    }
}
