<?php

namespace bitcream\gmvricambi\custom\api\controllers;

use yii\rest\ActiveController;
use bitcream\gmvricambi\custom\api\models\Order;
use Yii;
use yii\db\Query;
use yii\data\ActiveDataFilter;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

class OrderController extends ActiveController
{
    public $modelClass = 'bitcream\gmvricambi\custom\api\models\Order';

    /**
     * @inheritdoc
    */

    public function behaviors(): array
    {
        return array_merge(parent::behaviors(), [


            'authenticator' => [
                'class' => \Kakadu\Yii2JwtAuth\JwtBearerAuth::class,
                'except' => ['options'],
            ],
            'access'        => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ]);
    }

    public function actions(){
        $actions = parent::actions();

        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];

        return $actions;
    }

    public function prepareDataProvider(){

        $searchModel = new \bitcream\gmvricambi\custom\api\models\OrderSearch();
        return $searchModel->search(\Yii::$app->request->queryParams);

        // $filter = new ActiveDataFilter([
        //     'searchModel' => 'bitcream\gmvricambi\custom\api\models\OrderSearch'
        // ]);

        // $filterCondition = null;

        // // You may load filters from any source. For example,
        // // if you prefer JSON in request body,
        // // use Yii::$app->request->getBodyParams() below:
        // if ($filter->load(\Yii::$app->request->get())) {
        //     $filterCondition = $filter->build();
        //     if ($filterCondition === false) {
        //         // Serializer would get errors out of it
        //         return $filter;
        //     }
        // }
    }

    public function actionActivateOrder($id)
    {
        $model = Order::findOne($id);
        $model->activateOrder();
        return $model;
    }

    public function actionActiveOrder(){
        $activeOrder = CustomerUser::getCurrentUser()->getActiveOrder();
        if($activeOrder){
            $order = Order::findOne($activeOrder->id);
            //$order->updateTotal();
            return $order;
        }else{
            return "";
        }
    }

}
