<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\ProductAssembliesImage;
use bitcream\gmvricambi\custom\backend\models\ProductAssembliesImageSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * ProductAssembliesImageController implements the CRUD actions for ProductAssembliesImage model.
 */
class ProductAssembliesImageController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ProductAssembliesImage models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ProductAssembliesImageSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ProductAssembliesImage model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ProductAssembliesImage model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($assembly_id, $controller)
    {
        $model = new ProductAssembliesImage();
        $product_image = "";

        if ($model->load(Yii::$app->request->post())) {
            if($model->product_image){
                $model->image = Yii::$app->params['serverName'].$model->product_image[1]->href;        
                $model->assembly_id = $assembly_id;
                $model->image_id = $model->product_image[1]->id;
            }
            $model->save(false);
            return $this->redirect([$controller.'/index']);
        }

        return $this->render('create', [
            'model' => $model,
            'product_image' => $product_image,
        ]);
    }

    /**
     * Updates an existing ProductAssembliesImage model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $assembly_id, $controller)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            if($model->product_image){
                $image = $model->product_image[1];
                $model->image = Yii::$app->params['serverName'].$model->product_image[1]->href;   
                $model->assembly_id = $assembly_id;
                $model->image_id = $model->product_image[1]->id;             
            }
            $model->save(false);
            return $this->redirect([$controller.'/index']);
        }else{
            $product_image = $model->product_image;
        }

        return $this->render('update', [
            'model' => $model,
            'product_image' => $product_image,
        ]);
    }

    /**
     * Deletes an existing ProductAssembliesImage model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id, $controller)
    {
        $this->findModel($id)->delete();

        return $this->redirect([$controller.'/index']);
    }

    /**
     * Finds the ProductAssembliesImage model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ProductAssembliesImage the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ProductAssembliesImage::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
