<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;
use bitcream\gmvricambi\custom\backend\models\ProductImage;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            'filterModel' => $searchModel,
            //'searchModel' => $searchModel,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Image'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return (isset($data->image->image))? Html::img($data->image->image, ['class' => 'img-thumbnail'])  : ""; }
                ], 
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->AssemblyName, [Yii::$app->controller->id.'/view','id'=> $data->AssemblyID]);}
                ],      
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
    <?= $this->render('_modal')?>
</div>