<?php
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\widgets\ActiveForm;

use kartik\touchspin\TouchSpin;
use kartik\number\NumberControl;
use kartik\select2\Select2;
use bitcream\gmvricambi\custom\common\widget\AddPlantCodeWidget;

\yii\web\YiiAsset::register($this);
?>
<?php Modal::begin([
    'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'Update quantity product ').'<div class="article_cod"></div><br><div class="article_name"></div></h2>',
    'id'     => 'modal-update-quantity-product',
]); ?>
    <?php $form = ActiveForm::begin([
        'action' => ['update-quantity-product-to-order'],
        'method' => 'post',
        'id' => 'form-update-quantity-product'
    ]);
    ?>
    <div class='row'>
        <div class='col-md-12'>
            <div class='label-update-product'><?=Yii::t('gmv', 'To purchase this product, you must enter the plant code')?></div><br>
            <div class='row'>
                <div class='col-md-6 plant_code_block'>                    
                    <label for="plant_code"><?=Yii::t('gmv', 'Plant code')?></label>
                    <?= AddPlantCodeWidget::widget(['multiple' => false, 'search' => true]); ?>
                </div>
                <div class='quantity_block'>
                    <label for="dimension" class="label-dimension"><?=Yii::t('gmv', 'Dimension')?></label>
                    <div class="number">
                        <?= NumberControl::widget([
                            'name' => 'OrderItem[dimension]',
                            'id' => 'dimension',
                            'value' => null,
                        ]);?>
                    </div>
                    <label for="quantity" class="label-quantity"><?=Yii::t('gmv', 'Quantity')?></label>
                    <input type="hidden" id="quantity-update" name="OrderItem[quantity]" value="">
                    <input type="hidden" id="order-item-id" name="OrderItem[id]" value="">
                    <input type="hidden" id="order-id" name="OrderItem[order_id]" value="">
                    <div class="touchspin">
                        <?= TouchSpin::widget([
                            'name' => 'OrderItem[quantity]',
                            'id' => 'quantity-touchspin',
                            'pluginOptions' => [
                                'buttonup_class' => 'btn btn-primary', 
                                'buttondown_class' => 'btn btn-primary', 
                                'buttonup_txt' => '<i class="fa fa-plus-circle"></i>', 
                                'buttondown_txt' => '<i class="fa fa-minus-circle"></i>',
                                'step' => 1,
                                'initval' => 1,
                                'min' => 1,
                            ]
                        ]);?>
                    </div>
                    <br>
                </div>              
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <label for="note" class="label-note"><?=Yii::t('gmv', 'Note')?></label>
                    <textarea style="resize: none;" class="form-control" id="note" name="OrderItem[note]" rows="2"></textarea>
                </div>
            </div>
            <br>
            <div class='row'>
                <div class='col-md-12'>
                    <div id="availability"></div>
                </div>
            </div><br>
            <div class='row'>
                <div class='col-md-12'>
                    <?=Html::button(Yii::t('gmv', 'Update product'), ['class' => 'btn btn-default btn-block', 'id' => 'update-quantity-product-action-modal']);?>
                </div>
            </div>
        </div>
    </div>
    <?php ActiveForm::end();?>
<?php Modal::end(); ?>
