<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_assemblies_parts_articles}}".
 *
 * @property int $IDAssembly
 * @property int $IDPart
 * @property string $Article_cod
 * @property string $Notes
 */
class GMVAssembliesPartsArticles extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_assemblies_parts_articles}}';
    }

    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('gmv');
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['IDAssembly', 'IDPart', 'Article_cod', 'Notes'], 'required'],
            [['IDAssembly', 'IDPart'], 'integer'],
            [['Article_cod'], 'string', 'max' => 255],
            [['Notes'], 'string', 'max' => 300],
            [['IDAssembly', 'IDPart', 'Article_cod'], 'unique', 'targetAttribute' => ['IDAssembly', 'IDPart', 'Article_cod']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'IDAssembly' => Yii::t('gmv', 'Id Assembly'),
            'IDPart' => Yii::t('gmv', 'Id Part'),
            'Article_cod' => Yii::t('gmv', 'Article Cod'),
            'Notes' => Yii::t('gmv', 'Notes'),
        ];
    }
}
