<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the dropping of table `{{%GMV_PK}}`.
 */
class M210920094357DropColumnGMVPKToOrderTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {

        // drops index for column `GMV_PK`
        $this->dropIndex(
            '{{%idx-order-order_cod}}',
            '{{%order}}'
        );

        $this->dropColumn('{{%order}}', 'GMV_PK');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%order}}', 'GMV_PK', $this->string()->null());

        // creates index for column `GMV_PK`
        $this->createIndex(
            '{{%idx-order-order_cod}}',
            '{{%order}}',
            'GMV_PK'
        );

        // add foreign key for table `{{%GMV_order}}`
        $this->addForeignKey(
            '{{%fk-order-order_cod}}',
            '{{%order}}',
            'GMV_PK',
            '{{%GMV_order}}',
            'plant_cod',
            'CASCADE'
        );
    }
}
