<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVShippingAddress;
use bitcream\gmvricambi\custom\backend\models\GMVShippingAddressCustomerSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;

/**
 * GmvShippingAddressCustomerController implements the CRUD actions for GMVShippingAddress model.
 */
class GmvShippingAddressCustomerController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Finds the GMVShippingAddress model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $customer_cod
     * @param string $shipping_address_cod
     * @param string $datetime
     * @param string $business_name_address
     * @return GMVShippingAddress the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($customer_cod, $shipping_address_cod, $datetime, $business_name_address)
    {
        if (($model = GMVShippingAddress::findOne(['customer_cod' => $customer_cod, 'shipping_address_cod' => $shipping_address_cod, 'datetime' => $datetime, 'business_name_address' => $business_name_address])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }

    /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionShippingInfo($customer_cod, $shipping_address_cod, $datetime, $business_name_address)
    {
        return $this->render('shipping_info', [
            'model' => $this->findModel($customer_cod, $shipping_address_cod, $datetime, $business_name_address),
        ]);
    }

     /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionIndex()
    {
        // Yii::$app->user->id;
        // $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $searchModel = new GMVShippingAddressCustomerSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        // $dataProvider = new ActiveDataProvider([
        //     'query' => GMVShippingAddress::find()->where(["customer_cod" => $customerUser->customerCod])->all(),
        // ]);

        // $shipping = GMVShippingAddress::find(['customer_cod' => $customerUser->customerCod])->all();
        return $this->render('index', [
            // 'model' => $shipping,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
}
