<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;
use bitcream\gmvricambi\custom\common\behaviors\LanguageBehaviors;

/**
 * This is the model class for table "{{%product_image}}".
 *
 */
class ProductAssembliesImage extends \bitcream\gmvricambi\custom\common\models\ProductAssembliesImage
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'product_image',
                ],
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ]
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            // each category_id must exist in category table (*1)
            ['product_image', 'file', 'extensions' => ['jpg', 'png', 'jpeg', 'gif'], 'maxFiles' => 1],
        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'product_image' => Yii::t('gmv', 'Image'),
        ]);
    }
}
