<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Order reference'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->plant_cod, ['gmv-order/view','plant_cod'=>$data->order_reference]);}
                ],
                [
                    'label'  => Yii::t('gmv','Plant code'),
                    'value'  =>  (!empty($model->plant_reference))? json_encode(unserialize($model->plant_reference)) : Yii::t('gmv','Missing plant code'),
                    'contentOptions' => ['class' => (empty($model->plant_reference))? 'plant_message': ''],
                ],
                'order_status',
                [
                    'attribute' => 'order_confirmation_date',
                    'format' => ['date', 'php:d-m-Y']
                ], 
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>