<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use Emberware\Evidia\Model\GotifySender\behaviors\SendNotification;
use bitcream\gmvricambi\custom\common\behaviors\OrderItemUpdateParentBehaviors;
/**
 * This is the model class for table "{{%order_item}}".
 *
 */
class OrderItem extends base\OrderItem
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'send-notification' => [
                'class' => SendNotification::className(),
                'messageType' => [
                    'update' => 'orderItemUpdated',
                    'delete' => 'orderItemDeleted',
                    'create' => 'orderItemCreated',
                ]
            ],
            'update_parent' => [
                'class' => OrderItemUpdateParentBehaviors::className(),
            ],
        ]);
    }

    /**
     * Gets query for [[Order]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrder()
    {
        return $this->hasOne(Order::className(), ['id' => 'order_id']);
    }

    /**
     * Gets query for [[Order]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvArticle()
    {
        return $this->hasOne(GMVArticle::className(), ['article_cod' => 'article_cod']);
    }

    public static function searchOrderItem($articleCod, $order, $plantCode = NULL){
        $orderItem = OrderItem::find()->where(['article_cod' => $articleCod, 'order_id' => $order->id, 'status' => '30', 'plant_code' => $plantCode])->one();
        if($orderItem){
            return $orderItem;
        }
        return;
    }

    public static function searchShippingOrderItem($name, $order){
        $orderItem = OrderItem::find()->where(['name' => $name, 'order_id' => $order->id, 'status' => '30'])->one();
        if($orderItem){
            return $orderItem;
        }
        return;
    }


    public static function addShippingOrderItem($order, $cost){            
        $orderItem = OrderItem::searchShippingOrderItem("Shipping Cost", $order);
        if(!$orderItem){
            $orderItem = new OrderItem();
            $orderItem->name = "Shipping Cost";
            $orderItem->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $orderItem->name)));            
            $orderItem->status = "30";
            $orderItem->order_id = $order->id; 
        }       
        $orderItem->quantity = 1; 
        $orderItem->product_price = $cost;
        $orderItem->total_price = $cost;
        $orderItem->save();
        $total = $order->updateTotal();
    }

    public function updateTotal(){
        $this->total_price = (!empty($this->dimension))? $this->product_price * (float)$this->dimension:  $this->product_price * $this->quantity;
    }
}
