<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%category_image}}".
 *
 * @property int $id
 * @property string|null $category_id
 * @property string|null $image_id
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 */
class CategoryImage extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%category_image}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['category_id', 'image_id'], 'string'],
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'category_id' => Yii::t('gmv', 'Category ID'),
            'image_id' => Yii::t('gmv', 'Image ID'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
        ];
    }
}
