<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%product_assemblies_image}}".
 *
 * @property int $id
 * @property int|null $image_id
 * @property string|null $image
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $assembly_id
 */
class ProductAssembliesImage extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%product_assemblies_image}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['image_id', 'status', 'created_user_id', 'updated_user_id', 'assembly_id'], 'integer'],
            [['image'], 'string'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'image_id' => Yii::t('gmv', 'Image ID'),
            'image' => Yii::t('gmv', 'Image'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
            'assembly_id' => Yii::t('gmv', 'Assembly ID'),
        ];
    }
}
