<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%product_component}}".
 *
 * @property int $id
 * @property string|null $short_label
 * @property string|null $name
 * @property float|null $x_position
 * @property float|null $y_position
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property string $article_cod
 * @property int $category_id
 *
 * @property GMVArticle $articleCod
 * @property GMVArticlesCategory $category
 */
class ProductComponent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%product_component}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['x_position', 'y_position'], 'number'],
            [['status', 'created_user_id', 'updated_user_id', 'category_id'], 'integer'],
            [['article_cod', 'category_id'], 'required'],
            [['short_label', 'name', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['article_cod'], 'string', 'max' => 15],
            [['article_cod'], 'exist', 'skipOnError' => true, 'targetClass' => GMVArticle::className(), 'targetAttribute' => ['article_cod' => 'article_cod']],
            [['category_id'], 'exist', 'skipOnError' => true, 'targetClass' => GMVArticlesCategory::className(), 'targetAttribute' => ['category_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'short_label' => Yii::t('gmv', 'Short Label'),
            'name' => Yii::t('gmv', 'Name'),
            'x_position' => Yii::t('gmv', 'X Position'),
            'y_position' => Yii::t('gmv', 'Y Position'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
            'article_cod' => Yii::t('gmv', 'Article Cod'),
            'category_id' => Yii::t('gmv', 'Category ID'),
        ];
    }

    /**
     * Gets query for [[ArticleCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getArticleCod()
    {
        return $this->hasOne(GMVArticle::className(), ['article_cod' => 'article_cod']);
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(GMVArticlesCategory::className(), ['id' => 'category_id']);
    }
}
