<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVArticlePriceList;
use bitcream\gmvricambi\custom\backend\models\GMVArticlePriceListSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * GMVArticlePriceListController implements the CRUD actions for GMVArticlePriceList model.
 */
class GmvArticlePriceListController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVArticlePriceList models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVArticlePriceListSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVArticlePriceList model.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($price_list_cod, $customer_cod, $article_cod)
    {
        return $this->render('view', [
            'model' => $this->findModel($price_list_cod, $customer_cod, $article_cod),
        ]);
    }

    /**
     * Creates a new GMVArticlePriceList model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVArticlePriceList();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'price_list_cod' => $model->price_list_cod, 'customer_cod' => $model->customer_cod, 'article_cod' => $model->article_cod]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVArticlePriceList model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($price_list_cod, $customer_cod, $article_cod)
    {
        $model = $this->findModel($price_list_cod, $customer_cod, $article_cod);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'price_list_cod' => $model->price_list_cod, 'customer_cod' => $model->customer_cod, 'article_cod' => $model->article_cod]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVArticlePriceList model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($price_list_cod, $customer_cod, $article_cod)
    {
        $this->findModel($price_list_cod, $customer_cod, $article_cod)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVArticlePriceList model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $price_list_cod
     * @param string $customer_cod
     * @param string $article_cod
     * @return GMVArticlePriceList the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($price_list_cod, $customer_cod, $article_cod)
    {
        if (($model = GMVArticlePriceList::findOne(['price_list_cod' => $price_list_cod, 'customer_cod' => $customer_cod, 'article_cod' => $article_cod])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
