<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVArticlesCategory;
use bitcream\gmvricambi\custom\backend\models\Product;
use bitcream\gmvricambi\custom\backend\models\ProductImage;
use bitcream\gmvricambi\custom\backend\models\OrderItem;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * GmvArticleController implements the CRUD actions for GMVArticle model.
 */
class GmvArticlesCategoryCustomerController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVArticle models.
     * @return mixed
     */
    public function actionIndex()
    {
        $parentCategories = GMVArticlesCategory::findall(['category_parent_id' => 1]);
        return $this->render('index', [
            'parentCategories' => $parentCategories,
        ]);
    }

    /**
     * Finds the GMVArticle model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return GMVArticle the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GMVArticlesCategory::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
