<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVShippingAddress;
use bitcream\gmvricambi\custom\backend\models\GMVShippingAddressSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;

/**
 * GmvShippingAddressController implements the CRUD actions for GMVShippingAddress model.
 */
class GmvShippingAddressController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVShippingAddress models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVShippingAddressSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVShippingAddress model.
     * @param string $customer_cod
     * @param string $shipping_address_cod
     * @param string $datetime
     * @param string $business_name_address
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($customer_cod, $shipping_address_cod, $datetime, $business_name_address)
    {
        return $this->render('view', [
            'model' => $this->findModel($customer_cod, $shipping_address_cod, $datetime, $business_name_address),
        ]);
    }

    /**
     * Creates a new GMVShippingAddress model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVShippingAddress();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'customer_cod' => $model->customer_cod, 'shipping_address_cod' => $model->shipping_address_cod, 'datetime' => $model->datetime, 'business_name_address' => $model->business_name_address]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVShippingAddress model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $customer_cod
     * @param string $shipping_address_cod
     * @param string $datetime
     * @param string $business_name_address
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($customer_cod, $shipping_address_cod, $datetime, $business_name_address)
    {
        $model = $this->findModel($customer_cod, $shipping_address_cod, $datetime, $business_name_address);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'customer_cod' => $model->customer_cod, 'shipping_address_cod' => $model->shipping_address_cod, 'datetime' => $model->datetime, 'business_name_address' => $model->business_name_address]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVShippingAddress model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $customer_cod
     * @param string $shipping_address_cod
     * @param string $datetime
     * @param string $business_name_address
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($customer_cod, $shipping_address_cod, $datetime, $business_name_address)
    {
        $this->findModel($customer_cod, $shipping_address_cod, $datetime, $business_name_address)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVShippingAddress model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $customer_cod
     * @param string $shipping_address_cod
     * @param string $datetime
     * @param string $business_name_address
     * @return GMVShippingAddress the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($customer_cod, $shipping_address_cod, $datetime, $business_name_address)
    {
        if (($model = GMVShippingAddress::findOne(['customer_cod' => $customer_cod, 'shipping_address_cod' => $shipping_address_cod, 'datetime' => $datetime, 'business_name_address' => $business_name_address])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }

    /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionShippingInfo($customer_cod, $shipping_address_cod, $datetime, $business_name_address)
    {
        return $this->render('shipping_info', [
            'model' => $this->findModel($customer_cod, $shipping_address_cod, $datetime, $business_name_address),
        ]);
    }

     /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionIndexMy()
    {
        // Yii::$app->user->id;
        // $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $searchModel = new GMVShippingAddressSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        // $dataProvider = new ActiveDataProvider([
        //     'query' => GMVShippingAddress::find()->where(["customer_cod" => $customerUser->customerCod])->all(),
        // ]);

        // $shipping = GMVShippingAddress::find(['customer_cod' => $customerUser->customerCod])->all();
        return $this->render('index_my', [
            // 'model' => $shipping,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
}
