<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
/**
 * This is the model class for table "{{%GMVArticlesCategory}}".
 *
 */
class GMVArticlesCategory extends \bitcream\gmvricambi\custom\common\models\GMVArticlesCategory
{
    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategories()
    {
        return $this->hasMany(Category::className(), ['articles_category_id' => 'id']);
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(GMVArticlesCategory::className(), ['subcomponent_cod' => 'subcomponent_cod']);
    }
    

     /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategoryTranslation()
    {
        $categories = Category::find()->where(['articles_category_id' => $this->id, 'status' => '30'])->all();
        if(!empty($categories)){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        }         
        if(!empty($customerUser)){
            $language = $customerUser->customer->language;
        }
        if(!empty($language)){
            $category = Language::getTranslation($language, $categories); 
            return $category->name;
        }
        return $this->name;
    }

    
   
}
