<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVOrderOther;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use Yii;

/**
 * GMVOrderOtherSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVOrderOther`.
 */
class GMVOrderOtherSearch extends GMVOrderOther
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['plant_cod', 'order_reference', 'plant_reference', 'plant_type', 'order_confirmation_date', 'customer_cod', 'order_status'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVOrderOther::find();
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        if(isset($customerUser->customerCod)){
            $query->andFilterWhere(
                ['=', 'customer_cod', $customerUser->customerCod]
            );
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'order_confirmation_date' => $this->order_confirmation_date,
        ]);

        $query->andFilterWhere(['like', 'plant_cod', $this->plant_cod])
            ->andFilterWhere(['like', 'order_reference', $this->order_reference])
            ->andFilterWhere(['like', 'plant_reference', $this->plant_reference])
            ->andFilterWhere(['like', 'plant_type', $this->plant_type])
            ->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'order_status', $this->order_status]);

        return $dataProvider;
    }
}
