<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\ProductComponent;

/**
 * ProductComponentSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\ProductComponent`.
 */
class ProductComponentSearch extends ProductComponent
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'status', 'created_user_id', 'updated_user_id', 'category_id'], 'integer'],
            [['short_label', 'name', 'created_at', 'updated_at', 'article_cod'], 'safe'],
            [['x_position', 'y_position'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ProductComponent::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

         // grid filtering conditions
         $query->andFilterWhere(
            ['=', 'status', 30]
        );

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'x_position' => $this->x_position,
            'y_position' => $this->y_position,
            'status' => $this->status,
            'created_user_id' => $this->created_user_id,
            'updated_user_id' => $this->updated_user_id,
            'category_id' => $this->category_id,
        ]);

        $query->andFilterWhere(['like', 'short_label', $this->short_label])
            ->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'created_at', $this->created_at])
            ->andFilterWhere(['like', 'updated_at', $this->updated_at])
            ->andFilterWhere(['like', 'article_cod', $this->article_cod]);

        return $dataProvider;
    }
}
