<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \frontend\models\SignupForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;

$this->title = 'Sign in';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-signin">    

    <div class="row">
        <div class="col-sm-6 col-sm-offset-3">
            <h1><?= Html::encode($this->title) ?></h1>
            <p><?=Yii::t('gmv', 'Please fill out the following fields to signin:')?></p>

            <?php            
            $form = ActiveForm::begin([
                'id' => 'send-request-new-user',
                'action' => 'send-request-new-user',
                'method' => 'post'
            ]); ?>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'Business name')?></label>
                    <input type="text" name="business_name" placeholder="<?=Yii::t('gmv', 'Business name')?>" class="form-control">           
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'VAT number')?></label>
                    <input type="text" name="vat_number" placeholder="<?=Yii::t('gmv', 'VAT number')?>" class="form-control">           
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'Email')?></label>
                    <input type="email" name="email" placeholder="<?=Yii::t('gmv', 'Email')?>" class="form-control">           
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'Pec')?></label>
                    <input type="text" name="pec" placeholder="<?=Yii::t('gmv', 'Pec')?>" class="form-control">           
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'SDI recipient code')?></label>
                    <input type="text" name="sdi_recipient_code" placeholder="<?=Yii::t('gmv', 'SDI recipient code')?>" class="form-control">           
                </div>
            </div>
            <hr>
            <h4><?=Yii::t('gmv', 'Business address')?></h4>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'Address')?></label>
                    <input type="text" name="address" placeholder="<?=Yii::t('gmv', 'Address')?>" class="form-control">           
                </div>
            </div>            
            <div class="row">
                <div class="col-md-12">
                    <?php
                    echo '<label class="control-label">'.Yii::t('gmv', 'Province').'</label>';
                    echo Select2::widget([
                        'name' => 'province',
                        'data' => ArrayHelper::map($provinces, 'description', 'description'),
                        'options' => [
                            'placeholder' => 'Select province ...', 
                        ],
                    ]);
                    ?>         
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'Postal code')?></label>
                    <input type="number" name="postal_code" placeholder="<?=Yii::t('gmv', 'Postal code')?>" class="form-control">           
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <?php
                    echo '<label class="control-label">'.Yii::t('gmv', 'Country').'</label>';
                    echo Select2::widget([
                        'name' => 'country',
                        'data' => ArrayHelper::map($countries, 'description', 'description'),
                        'options' => [
                            'placeholder' => 'Select country ...', 
                        ],
                    ]);
                    ?>          
                </div>
            </div>
            <hr>
            <h4><?=Yii::t('gmv', 'Shipping address')?></h4>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'Address')?></label>
                    <input type="text" name="address_shipping" placeholder="<?=Yii::t('gmv', 'Address')?>" class="form-control">           
                </div>
            </div>            
            <div class="row">
                <div class="col-md-12">
                <?php
                    echo '<label class="control-label">'.Yii::t('gmv', 'Province').'</label>';
                    echo Select2::widget([
                        'name' => 'province_shipping',
                        'data' => ArrayHelper::map($provinces, 'description', 'description'),
                        'options' => [
                            'placeholder' => 'Select province ...', 
                        ],
                    ]);
                    ?>   
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label><?=Yii::t('gmv', 'Postal code')?></label>
                    <input type="number" name="postal_code_shipping" placeholder="<?=Yii::t('gmv', 'Postal code')?>" class="form-control">           
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                <?php
                    echo '<label class="control-label">'.Yii::t('gmv', 'Country').'</label>';
                    echo Select2::widget([
                        'name' => 'country_shipping',
                        'data' => ArrayHelper::map($countries, 'description', 'description'),
                        'options' => [
                            'placeholder' => 'Select country ...', 
                        ],
                    ]);
                    ?>         
                </div>
            </div>
            
            <br>
            <div class="form-group">
                <?= Html::submitButton('Signup', ['class' => 'btn btn-primary', 'name' => 'signup-button']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>

    
</div>
