<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;
use bitcream\gmvricambi\custom\backend\models\ProductImage;
use yii\bootstrap\Modal;
use bitcream\gmvricambi\custom\common\models\GMVArticle;
?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            'filterModel' => $searchModel,
            //'searchModel' => $searchModel,
            'columns' => [
                [   
                    'attribute'=>Yii::t('gmv', 'Image'),
                    'format'=>'raw',
                    'value' => function($data)
//                    { return (isset($data->coverImage->image))? Html::img($data->coverImage->image, ['class' => 'img-thumbnail'])  : ""; }
                    { return (isset($data->coverImage->image))? Html::img($data->coverImage->cover_image->getPreviewWebPath(100), ['class' => 'img-thumbnail'])  : ""; }
                ],
                ['attribute'=>Yii::t('gmv', 'Article cod'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->article_cod, [Yii::$app->controller->id.'/view','article_cod'=>$data->article_cod]);}
                ],                
                [   
                    'attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    { return $data->productTranslation; }
                ],
                [
                    'attribute' => Yii::t('gmv', 'Category'),
                    'value' => function($data)
                    { return (!empty($data->category->categoryTranslation))? $data->category->categoryTranslation: ""; }
                ],
                [   
                    'attribute'=>Yii::t('gmv', 'Price'),
                    'format'=>'raw',
                    'value' => function($data)
                    { return $data->price; }
                ],
                // 'assembled_product',
                [
                    'format'=>'raw',
                    'label' => Yii::t('gmv','Actions'),
                    'value' => function($data)
                    {
                        return Html::button("<i class='fa fa-plus'></i> ".Yii::t('gmv', 'Add product to order'),  [                                                       
                            'data-toggle' => 'modal',
                            'data-target' => '#modal',
                            'data-id'     => $data->article_cod,
                            'data-plant'     => $data->need_PK_order,
                            'data-name'   => $data->isDynamicDimension(),
                            'data-description'   => $data->productTranslation,
                            'data-availability'   => $data->checkAvailability(),
                            'data-quote'   => $data->quote_shipping,
                            'id'          => 'popupModalAddProduct',      
                            'class' => 'btn btn-success popup-modal-add-product',                  
                        ]);
                    }
                ]
            ],
            'clientOptions' => [
                "order" => [[2, "asc"]],
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
    <?= $this->render('_modal')?>
</div>
