<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_articles_category}}".
 *
 * @property int $id
 * @property int|null $category_parent_id
 * @property string|null $name
 * @property int|null $subcomponent_cod
 *
 * @property ProductComponent[] $productComponents
 */
class GMVArticlesCategory extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        return \Yii::$app->gmv;  
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_articles_category}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['category_parent_id', 'subcomponent_cod'], 'integer'],
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'category_parent_id' => Yii::t('gmv', 'Category Parent ID'),
            'name' => Yii::t('gmv', 'Category'),
            'subcomponent_cod' => Yii::t('gmv', 'Subcomponent Cod'),
        ];
    }

    /**
     * Gets query for [[ProductComponents]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductComponents()
    {
        return $this->hasMany(ProductComponent::className(), ['category_id' => 'id']);
    }
}
