<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_assemblies}}".
 *
 * @property int $AssemblyID
 * @property string $AssemblyName
 * @property string $AssemblyImage
 */
class GMVAssemblies extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_assemblies}}';
    }

    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('gmv');
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['AssemblyID', 'AssemblyName', 'AssemblyImage'], 'required'],
            [['AssemblyID'], 'integer'],
            [['AssemblyName', 'AssemblyImage'], 'string', 'max' => 255],
            [['AssemblyID'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'AssemblyID' => Yii::t('gmv', 'Assembly ID'),
            'AssemblyName' => Yii::t('gmv', 'Assembly Name'),
            'AssemblyImage' => Yii::t('gmv', 'Assembly Image'),
        ];
    }
}
