<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVAssemblies;
use bitcream\gmvricambi\custom\backend\models\GMVAssembliesParts;
use bitcream\gmvricambi\custom\backend\models\GMVAssembliesPartsArticles;
use bitcream\gmvricambi\custom\backend\models\GMVAssembliesPartsArticlesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GMVAssembliesPartsArticlesController implements the CRUD actions for GMVAssembliesPartsArticles model.
 */
class GmvAssembliesPartsArticlesController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVAssembliesPartsArticles models.
     * @return mixed
     */
    public function actionIndex()
    {
       // $gmvAssemblies = GMVAssemblies::findOne(Yii::$app->request->queryParams['assembly_id']);
        $searchModel = new GMVAssembliesPartsArticlesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            //'gmvAssemblies' => $gmvAssemblies,
            //'gmvAssembliesParts' => $gmvAssembliesParts,
        ]);
    }

    /**
     * Displays a single GMVAssembliesPartsArticles model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id, $id_part, $article_cod)
    {
        $gmvAssemblies = GMVAssemblies::findOne($id);
        $model = GMVAssembliesPartsArticles::find()
                                        ->where(['IDAssembly' => $id,
                                                'IDPart' => $id_part,
                                                'Article_cod' => $article_cod])
                                        ->one();
        $gmvAssembliesParts = GMVAssembliesParts::find()
                        ->where(['Assembly_ID' => $id,
                                'Assembly_Part' => $id_part])
                        ->one();
        return $this->render('view', [
            'model' => $model,
            'gmvAssemblies' => $gmvAssemblies,
            'gmvAssembliesParts' => $gmvAssembliesParts,
            'id' => $id,
            'id_part' => $id_part,
        ]);
    }

    /**
     * Creates a new GMVAssembliesPartsArticles model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVAssembliesPartsArticles();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->Article_cod]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVAssembliesPartsArticles model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->Article_cod]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVAssembliesPartsArticles model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVAssembliesPartsArticles model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return GMVAssembliesPartsArticles the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GMVAssembliesPartsArticles::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
