<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use bitcream\gmvricambi\custom\backend\models\CategoryImage;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->name, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                ],
                'category_parent_id',
                [
                    'format'=>'raw',
                    'label' => Yii::t('gmv', 'Action'),
                    'value' => function ($model, $key, $index, $column) use ($languages)
                    {
                        $arrLang = array();
                        //Get product with article_cod
                        $htmlButtons = "";
                        // $model->products;
                        $categoryImage = CategoryImage::find()->where(['category_id' => $model->id])->one();
                        if(!isset($categoryImage->id)){
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-plus"></i> <i class="fa fa-picture-o"></i>'), ['category-image/create', 'articleCategory' => $model->id], ['class' => 'btn btn-primary action-button']);
                        }else{
                            // $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-pencil"></i> <i class="fa fa-picture-o"></i>'), ['category-image/update', 'articleCategory' => $model->id, 'id'=> $categoryImage->id], ['class' => 'btn btn-primary action-button']);
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-trash-o"></i> <i class="fa fa-picture-o"></i>'), ['category-image/delete', 'id'=> $categoryImage->id], [
                                    'class' => 'btn btn-danger action-button',
                                    'data' => [
                                        'confirm' => Yii::t('gmv','Are you sure you want to delete this category image?'),
                                        'method' => 'post',
                                    ]
                                ]);
                        }

                        if($model->categories){
                            foreach($model->categories as $category){
                                $lang = $category->getLanguageObject();                               
                                
                                if($lang){
                                    if($lang->label == "en"){
                                        $country = "gb";
                                    }else{
                                        $country = $lang->label;
                                    }
                                    $flag = FlagIcon::widget([
                                        'countryCode' => $country,
                                        'options' => [
                                            'class' => 'flag-button'
                                        ]                            
                                    ]);

                                    array_push($arrLang, $lang->label);
                                    
                                    $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-pencil"></i>', ['flag' => $flag]), ['category/update', 'id' => $category->id, 'articleCategory' => $model->id], ['class' => 'btn btn-warning action-button']);
                                    $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-trash-o"></i>', ['flag' => $flag]), ['category/delete', 'id'=> $category->id], 
                                        [
                                            'class' => 'btn btn-danger action-button',
                                            'data' => [
                                                'confirm' => Yii::t('gmv','Are you sure you want to delete this category?'),
                                                'method' => 'post',
                                            ]
                                        ]);
                                }
                            }
                        }

                        foreach($languages as $language) 
                        {
                            if (!in_array($language, $arrLang)) {
                                if($language == "en"){
                                    $country = "gb";
                                }else{
                                    $country = $language;
                                }
                                $flag = FlagIcon::widget([
                                    'countryCode' => $country,
                                    'options' => [
                                        'class' => 'flag-button'
                                    ]                            
                                ]);                               

                                $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-plus"></i>', ['flag' => $flag]), ['category/create', 'lang_create' => $language, 'articleCategory' => $model->id], ['class' => 'btn btn-success action-button']);
                            }
                        }

                       

                        return $htmlButtons;
                       
                    }
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>
